<?php 

    $data_peserta = $this->DataPeserta;
    
    if (!$data_peserta->FotoProfil && $data_peserta->JenisKelamin == 'Pria')
        $data_peserta->FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
    elseif (!$data_peserta->FotoProfil && $data_peserta->JenisKelamin == 'Wanita')
        $data_peserta->FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-female.png'; 
        
?>
    
    <div class="page-content-col">
        <!-- BEGIN PAGE BASE CONTENT -->
        <div class="row">
            <div class="col-md-12">

                <?php include("sidebar.php") ?>

                <!-- BEGIN PROFILE CONTENT -->
                <div class="profile-content">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light bordered">
                                <div class="portlet-title tabbable-line">
                                    <div class="caption caption-md">
                                        <i class="icon-globe theme-font hide"></i>
                                        <span class="caption-subject font-blue-madison bold uppercase">Personal Information</span>
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <form role="form" action="#">
                                        <div class="form-group">
                                            <label class="control-label">Nama Lengkap</label>
                                            <input type="text" value="<?= $data_peserta->Nama ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Email</label>
                                            <input type="text" value="<?= $data_peserta->Email ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">No. Telepon</label>
                                            <input type="text" value="<?= $data_peserta->Telepon ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Jenis Kelamin</label>
                                            <input type="text" value="<?= $data_peserta->JenisKelamin ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Tanggal Lahir</label>
                                            <input type="text" value="<?= $data_peserta->TanggalLahir ? Website_Helper::indonesiaDate(strtotime($data_peserta->TanggalLahir->date), 'd F  Y') : '' ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Tingkat Pendidikan</label>
                                            <input type="text" value="<?= $data_peserta->TingkatPendidikan ?>" class="form-control" readonly /> 
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">Nomor Induk Pegawai (NIP)</label>
                                            <input type="text" value="<?= $data_peserta->NIP ?>" class="form-control" readonly /> 
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END PROFILE CONTENT -->
            </div>
        </div>
        <!-- END PAGE BASE CONTENT -->
    </div>

    <script type="text/javascript">
    
        $(document).ready(function(){

        });

        $('.nav.nav-tabs a').click(function () {
            $('.caption-subject').html($(this).html());
        });

    </script>
