<?php 

    $data = $this->data;

?>
    
    <style>
        form .form-group .error-message{
            color: red;
        }
    </style>

    <script type="text/javascript" src="/modules/sabos/views/layouts/static/js/custom/validator.js"></script>

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> Manajemen Data Unit Organisasi</span>
            </div>
            <div class="tools"> </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row  text-center">
                    <div class="btn-group">
                        <button class="btn sbold green btn-add"> Tambah Baru
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th class="all"> Nama </th>
                        <th> Jumlah Peserta </th>
                        <th class="all">  </th>
                    </tr>
                </thead>
                <tbody>

                <?php foreach($data as $key => $temp) { ?>

                    <tr class="odd gradeX">
                        <td> <?= $temp->Nama ?> </td>
                        <td> 
                            <a href="/sabos/peserta/manajemen-data?unit-organisasi=<?= $temp->o_id ?>" style="text-decoration: none; color: inherit;">
                                <div> <?= $temp->Peserta ?> </div>
                            </a> 
                        </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> <i class="icon-settings"></i>
                                    <i class="fa fa-angle-down"></i>
                                </button>
                                <ul class="dropdown-menu pull-left" role="menu">
                                    <li>
                                        <a href="/sabos/unit-organisasi/peserta?id=<?= $temp->o_id ?>" target="_blank">
                                            <i class="icon-eye"></i> Lihat Detail 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="editData(<?= $key ?>,<?= $temp->o_id ?>)">
                                            <i class="icon-pencil"></i> Ubah 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="deleteData(<?= $key ?>,<?= $temp->o_id ?>)">
                                            <i class="icon-fire"></i> Hapus 
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>

                <?php } ?>

                </tbody>
            </table>
        </div>
    </div>

    <div id="modal-form" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-full">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title">Modal Title</h4>
                </div>
                <div class="modal-body">
                    <form id="form-data" role="form" class="form-horizontal" onsubmit="return false">
                        <div class="form-body">

                            <div class="form-group ">
                                <label class="col-md-2 control-label">Nama Unit Organisasi</label>
                                <div class="col-md-10">
                                    <input type="hidden" class="form-control" name="Id">
                                    <input type="text" class="form-control" name="Nama" placeholder="Masukan nama unit organisasi">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-outline dark">Batal</button>
                    <button type="button" class="btn green" onclick="submitForm()">Simpan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <script type="text/javascript">

        var corpus = JSON.parse('<?= json_encode($data) ?>');

        $(document).ready( function() {

            initValidation();

        });

        $('.btn-add').on("click",function(){
            $('#modal-form .modal-title').html('Tambah Data Unit Organisasi');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error
            $('#form-data .form-control').val('');

            $('#modal-form').modal('show');
        });                            

        function editData(key, Id){
            $('#modal-form .modal-title').html('Ubah Data Unit Organisasi');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error

            var data = corpus[key];
            $('#form-data .form-control').each( function(key, element){
                $(this).val(data[$(this).attr('name')]);
            });

            $("input[name='Id']").val(Id);

            $('#modal-form').modal('show');
        }

        function deleteData(key, Id){
            var data = corpus[key];

            bootbox.dialog({
                message: "Apakah Anda yakin menghapus <b>'" + data['Nama'] + "'</b>. <br /><br /><b>Berhati-hatilah</b> dalam menghapus data.",
                title: "Informasi Penting",
                buttons: {
                    success: {
                        label: "Ya",
                        className: "green",
                        callback: function() {

                            $.ajax({            
                                type : 'post',
                                url  : "/api/unit-organisasi/delete",
                                data : { 
                                    Id : Id,
                                },
                                timeout: 45000,
                                success:function(response){
                                    response = JSON.parse(response);
                                    if(response.Status){
                                        location.reload();
                                    }else{
                                        hideLoading();
                                        swal(response.Message, "", "error")
                                    }
                                },
                                error: function(response){
                                    hideLoading();
                                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                                }
                            });                   

                        }
                    },
                    danger: {
                        label: "Tidak",
                        className: "red",
                    }
                }
            });
        }
        
        function initValidation(){            
            var frmvalidator  = new Validator("form-data");
            
            frmvalidator.EnableOnPageErrorDisplay();
            frmvalidator.EnableMsgsTogether();
            
            frmvalidator.addValidation("Nama", "required", "Nama lengkap harus diisi");
            frmvalidator.addValidation("Nama", "alphanumeric_space", "Nama lengkap hanya boleh diisi alphanumerik dan spasi");

            // set callback function after pass all of validation
            frmvalidator.setCallbackFunction('submitForm()');
        }

        function getData(){
            
            var data = new Object;
            $('#form-data .form-control').each( function(key, element){
                data[$(this).attr('name')] = $(this).val();
            });

            data.IdOrganisasi = "<?= $_GET['id'] ?>";

            return data;

        }

        function submitForm(){
            showLoading();

            var id =  $("input[name='Id']").val();
            var url = id ? "/api/unit-organisasi/update" : "/api/unit-organisasi/create";

            console.log(url);
            $.ajax({            
                type : 'post',
                url  : url,
                data : { 
                    Data : getData(),
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    if(response.Status){
                        location.reload();
                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            });         ;            
        }

        var table = $('table');
        table.dataTable({

            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Belum ada data",
                "info": "Menampilkan _START_ - _END_ dari _TOTAL_ data",
                "infoEmpty": "Tidak ada data yang ditemukan",
                "infoFiltered": "(filtered1 from _MAX_ total records)",
                "lengthMenu": "Menampilkan _MENU_",
                "search": "Cari:",
                "zeroRecords": "Tidak ada data yang ditemukan",
                "paginate": {
                    "previous":"Prev",
                    "next": "Next",
                    "last": "Last",
                    "first": "First"
                }
            },

            "lengthMenu": [
                [5, 10, 15, 20, -1],
                [5, 10, 15, 20, "All"] // change per page values here
            ],
            // set the initial value
            "pageLength": 5,            
            "pagingType": "bootstrap_full_number",
            "responsive": {
                details: {
                   
                }
            },
            "columnDefs": [
                {  // set default column settings
                    'orderable': false,
                    'targets': [2]
                }, 
                {
                    "searchable": false,
                    "targets": [2]
                }
            ],
            "order": [
                [0, "asc"]
            ]
        });

    </script>
