<?php

use Website\Controller\Action;

class ActivityController extends Action
{

    public function defaultAction()
    {
        // get activity
        $activities = new Object\WebsiteActivity\Listing();
        $activities->setOrderKey('Date');
        $activities->setOrder('DESC');
        $activities->setLimit(6);
        $activities = $activities->load();      

        $this->view->Activities = $activities;
        $this->enableLayout();
    }   

    public function detailAction()
    {
        $key = $_GET['key'] ?  $_GET['key'] : $this->_getParam('key');

        $activity = new Object\WebsiteActivity\Listing();
        $activity->setCondition("o_key = '".$key."'");
        $activity = $activity->load()[0];

        if(!$key || !$activity){
            Website_Helper::redirect('/error404');
        }

        Website_Helper::setSeoOnPage(
                $activity->Title . " | Activity Sinergi Consulting", 
                $activity->Summary, 
                "activity,consulting,story", 
                $activity->Title, 
                $activity->Title, 
                $activity->Title
            );

        $other_activity = new Object\WebsiteActivity\Listing();
        $other_activity->setOrderKey("RAND()", false);
        $other_activity->setLimit(6);
        $other_activity->setCondition("o_id <> ?", $activity->o_id);
        $other_activity = $other_activity->load();      

        $this->view->Activity = $activity;
        $this->view->OtherActivity = $other_activity;
        $this->enableLayout();
    }   

}
