<?php

use Website\Controller\Action;

class BusinessController extends Action
{

    public function defaultAction()
    {
    	// get business records
        $pathId = Object_Abstract::getByPath("/website/business")->o_id; // get id path folder

		$business = new Object\WebsiteBusiness\Listing();
		$business->setCondition('o_parentId = '. $pathId);
		$business->setOrderKey('OrderIndex');
		$business->setOrder('ASC');
		$business = $business->load();

    	// get products records by business
    	$service_business = [];
		foreach ($business as $key => $obj) {			
			$services = new Object\WebsiteService\Listing();
			$services->setCondition("CategoryBusiness like ?", "%,object|" . $obj->o_id . ",%");
			$services->setOrderKey('OrderIndex');
			$services->setOrder('ASC');

			$service_business[$obj->o_id] = $services->load();
		}

		$this->view->Business = $business;
		$this->view->Services = $service_business;
	    $this->enableLayout();
    }

}
