<?php

use Website\Controller\Action;

class DefaultController extends Action
{

    public function defaultAction()
    {

    	// get client for homepage
		$clients = new Object\WebsiteClient\Listing();
		$clients->setCondition('ShowHome = 1');
		$clients->setOrderKey('OrderIndex');
		$clients->setOrder('ASC');
		$clients = $clients->load();

    	// get partner for homepage
		$partners = new Object\WebsitePartner\Listing();
		$partners->setCondition('ShowHome = 1');
		$partners->setOrderKey('OrderIndex');
		$partners->setOrder('ASC');
		$partners = $partners->load();		

    	// get consultant for homepage
        $consultants = new Object\WebsiteConsultant\Listing();
		$consultants->setCondition('ShowHome = 1');
        $consultants->setOrderKey('OrderIndex');
        $consultants->setOrder('ASC');
        $consultants = $consultants->load();

        // get activity
        $activities = new Object\WebsiteActivity\Listing();
        $activities->setOrderKey('Date');
        $activities->setOrder('DESC');
        $activities->setLimit(3);
        $activities = $activities->load();      

        $this->view->Activities = $activities;
		$this->view->Clients = $clients;
		$this->view->Partners = $partners;
		$this->view->Consultants = $consultants;

	    $this->enableLayout();
    }	

    public function errorPagesAction()
    {
	    $this->enableLayout();
    }	

    public function downloadAction()
    {
        $key = $_GET['f'] ?  $_GET['f'] : $this->_getParam('key');

        $asset = new Object\WebsiteAssets\Listing();
        $asset->setOrderKey("o_id");
        $asset->setOrder("desc");
        $asset->setCondition("PathUrl = '".$key."'");
        $asset = $asset->load()[0];

        if(!$asset)
            Website_Helper::redirect('/error404');

        $now = new \DateTime();
        if($asset->StartDate){
            if($now < $asset->StartDate){
                 Website_Helper::redirect('/error404');
            }
        }
        if($asset->EndDate){
            if($now > $asset->EndDate){
                Website_Helper::redirect('/error404');
            }
        }

        if($asset->ExternalLink){
            if($asset->ExternalLink->direct){
                if(!Website_Helper::getSession('DOWNLOAD_ASSETS_' . $key)){
                    $asset->CounterDownload = $asset->CounterDownload ? ($asset->CounterDownload+1) : 1;
                    $asset->save();
                    Website_Helper::setSession('DOWNLOAD_ASSETS_' . $key,  1);      
                }
                
                Website_Helper::redirect($asset->ExternalLink->direct);
            } else {
                Website_Helper::redirect('/error404');                
            }
        }        

        $this->view->Key = $key;
        $this->enableLayout();
    }

    public function doDownloadAction()
    {
        $key = $_GET['f'] ?  $_GET['f'] : $this->_getParam('key');

        $asset = new Object\WebsiteAssets\Listing();
        $asset->setCondition("PathUrl = '".$key."'");
        $asset = $asset->load()[0];

        if(!$asset)
            Website_Helper::redirect('/error404');

        $now = new \DateTime();
        if($asset->StartDate){
            if($now < $asset->StartDate){
                 Website_Helper::redirect('/error404');
            }
        }
        if($asset->EndDate){
            if($now > $asset->EndDate){
                Website_Helper::redirect('/error404');
            }
        }

        $file = '/var/www/sinergi/website/var/assets' . $asset->Asset->path . $asset->Asset->filename;
        $name = $asset->Asset->filename;
        $mime_type = $asset->Asset->mimetype;

        if(!Website_Helper::getSession('DOWNLOAD_ASSETS_' . $key)){
            $asset->CounterDownload = $asset->CounterDownload ? ($asset->CounterDownload+1) : 1;
            $asset->save();
            Website_Helper::setSession('DOWNLOAD_ASSETS_' . $key,  1);      
        }
    
        Website_Helper::downloadFile($file, $name, $mime_type);
    }  

}
