<?php

use Website\Controller\Action;

class ProfileController extends Action
{

    public function aboutUsAction()
    {
	    $this->enableLayout();
    }	

    public function ourPartnerAction()
    {
        // get partner
        $partners = new Object\WebsitePartner\Listing();
        $partners->setOrderKey('OrderIndex');
        $partners->setOrder('ASC');
        $partners = $partners->load();      

        $this->view->Partners = $partners;
        $this->enableLayout();
    }

    public function ourClientAction()
    {
        // get client category
        $pathId = Object_Abstract::getByPath("/website/clients")->o_id; // get id path folder

        $category = new Object\WebsiteClientCategory\Listing();
        $category->setCondition('o_parentId = '. $pathId);
        $category->setOrderKey('OrderIndex');
        $category->setOrder('ASC');
        $category = $category->load();

        // get products records by business
        foreach ($category as $key => $obj) {           
            // get client
            $clients = new Object\WebsiteClient\Listing();
            $clients->setCondition('o_parentId = '. $obj->o_id);
            $clients->setOrderKey('OrderIndex');
            $clients->setOrder('ASC');
            $clients = $clients->load();

            $category[$key]->Clients = $clients;
        }

        $this->view->Clients = $category;
        $this->enableLayout();
    }

    public function ourConsultantAction()
    {
        // get consltant
        $consultant = new Object\WebsiteConsultant\Listing();
        $consultant->setOrderKey('OrderIndex');
        $consultant->setOrder('ASC');
        $consultant = $consultant->load();

        $this->view->Consultant = $consultant;
        $this->enableLayout();
    }

    public function consultantDetailAction()
    {
        $key = $_GET['key'] ?  $_GET['key'] : $this->_getParam('key');

        $path = "/website/consultans/" . $key;
        $consultant = Object\WebsiteConsultant::getByPath($path);

        if(!$key || !$consultant){
            Website_Helper::redirect('/error404');
        }

        Website_Helper::setSeoOnPage(
                $consultant->Name . " | Consultant Sinergi Consulting", 
                $consultant->Summary, 
                "service,consulting,consultant", 
                $consultant->Name, 
                $consultant->Name, 
                $consultant->Name
            );


        $this->view->Consultant = $consultant;
	    $this->enableLayout();
    }	

}
