<?php

use Website\Controller\Action;

class ServicesController extends Action
{

    public function defaultAction()
    {
        $all_service = [];

        // get all service sector
        $pathId = Object_Abstract::getByPath("/website/services")->o_id; // get id path folder

        $sectors = new Object\WebsiteServiceSector\Listing();
        $sectors->setCondition('o_parentId = '. $pathId);
        $sectors->setOrderKey('OrderIndex');
        $sectors->setOrder('ASC');
        $sectors = $sectors->load();

        // get scope by sector
        foreach ($sectors as $key1 => $obj1) {           
            $all_service[$key1] = $obj1;

            $scopes = new Object\WebsiteServiceScope\Listing();
            $scopes->setCondition('o_parentId = '. $obj1->o_id);
            $scopes->setOrderKey('OrderIndex');
            $scopes->setOrder('ASC');
            $scopes = $scopes->load();

            // get service by scope
            foreach ($scopes as $key2 => $obj2) {           
    
                $services = new Object\WebsiteService\Listing();
                $services->setCondition('o_parentId = '. $obj2->o_id);
                $services->setOrderKey('OrderIndex');
                $services->setOrder('ASC');
                $services = $services->load();

                $all_service[$key1]->Scopes[$key2] = $obj2;
                $all_service[$key1]->Scopes[$key2]->Services = $services;

            }

        }

        $this->view->Services = $all_service;
        $this->enableLayout();
    }   

    public function detailAction()
    {
        $key = $_GET['key'] ?  $_GET['key'] : $this->_getParam('key');

        $service = new Object\WebsiteService\Listing();
        $service->setCondition("o_key = '".$key."'");
        $service = $service->load()[0];

        if(!$key || !$service){
            Website_Helper::redirect('/error404');
        }

        Website_Helper::setSeoOnPage(
                $service->Name . " | Service Sinergi Consulting", 
                $service->Summary, 
                "service,consulting,planing", 
                $service->Name, 
                $service->Name, 
                $service->Name
            );

        $this->view->Service = $service;
        $this->enableLayout();
    }       
    
    public function exportAction()
    {
        $contents = [];

        $services = new Object\WebsiteService\Listing();
        $services = $services->load();

        foreach ($services as $key => $value) {
            $temp_content = [];
            if($value->Content){            
                foreach ($value->Content->items as $content) {
                    $content->object = null;
                    array_push($temp_content, $content);
                }
            }


            $temp = [];
            $temp['Path'] = $value->o_path . $value->o_key;
            $temp['Content'] = $temp_content;               

            array_push($contents, $temp);
        }

        $contents = json_encode($contents);

        try {
            file_put_contents("website/var/services.txt", $contents);
            die('Berhasil export data services');
        } catch(Exception $ex) {
            die('Gagal export data services');        
        }
    }   

    public function importAction()
    {
        try{
            $text = file_get_contents("website/var/services.txt");
            $content = json_decode($text);
            
            foreach ($content as $content) {
                if($content->Content){            
                    $collections = new Object\Fieldcollection();
                    foreach ($content->Content as $item) {
                        if($item->type == 'Paragraf') $collection = new Object\Fieldcollection\Data\Paragraf();
                        if($item->type == 'Image') $collection = new Object\Fieldcollection\Data\Image();
                        if($item->type == 'Video') $collection = new Object\Fieldcollection\Data\Video();
                        if($item->type == 'Wysiwyg') $collection = new Object\Fieldcollection\Data\Wysiwyg();

                        foreach ($item as $key_collection => $value_collection) {
                            if($key == 'type') continue;
                            $collection->$key_collection = $value_collection;                        
                        }
                        
                        if($item->type == 'Image'){
                            try{                            
                                $image = Asset\Image::getByPath($item->Content->path . $item->Content->filename);
                                $collection->Content = $image;
                            } catch (Exception $ex) { }
                        }

                        $collections->add($collection);
                    }
                    
                    $service = Object_Abstract::getByPath($content->Path);
                    $service->setContent($collections);
                    $service->save();
                }
            }
            
            die("Berhasil import data services");
        } catch(Exception $ex) {
            die('Gagal import data services');        
        }
    }
        
}
