<?php
/**
* This file is called directly after the pimcore startup (/pimcore/config/startup.php)
* Here you can do some modifications before the dispatch process begins, this includes some Zend Framework plugins
* or some other things which should be done before the initialization of pimcore is completed.
* ADDED BY AHMAD SOMADI
*/

if (!defined("WEBSITE_MODULE_PATH"))  
    define("WEBSITE_MODULE_PATH", PIMCORE_DOCUMENT_ROOT . "/modules");

$front = \Zend_Controller_Front::getInstance();
$front->addModuleDirectory(PIMCORE_DOCUMENT_ROOT . "/modules");

$router = $front->getRouter();

// ################################################################################################
// ## TO AUTOROUTE WEBSITE MODULES
// ## ADDED BY AHMAD SOMADI
// ################################################################################################

    $routeCustom = new \Zend_Controller_Router_Route(
        '/:controller/:action/*',
        array(
            'module'       => 'website',
            "controller"   => "default",
            "action"       => "default"
            )
        );

    $router->addRoute('website', $routeCustom);

// ################################ END AUTOROUTE WEBSITE MODULES #################################   



// ################################################################################################
// ## TO REGISTER AND AUTOROUTE API MODULES
// ## ADDED BY AHMAD SOMADI
// ################################################################################################

    $autoloader = \Zend_Loader_Autoloader::getInstance();
    $autoloader->registerNamespace('Api');

    set_include_path(implode(PATH_SEPARATOR, array(
        WEBSITE_MODULE_PATH . '/api/lib',
        get_include_path(),
        )));

    $resourceLoader = new \Zend_Application_Module_Autoloader(array(
        'namespace' => 'Api',
        'basePath' =>  WEBSITE_MODULE_PATH . "/api",
        ));

    $routeApi = new \Zend_Controller_Router_Route(
        'api/:controller/:action/*',
        array(
            'module'       => 'api',
            "controller"   => "default",
            "action"       => "default"
            )
        );

    $router->addRoute("api", $routeApi);

// ################################ END API MODULES ############################################   


// ################################################################################################
// ## TO REGISTER AND AUTOROUTE CUSTOM MODULES
// ## ADDED BY AHMAD SOMADI
// ################################################################################################

    $autoloader = \Zend_Loader_Autoloader::getInstance();
    $autoloader->registerNamespace('Custom');

    set_include_path(implode(PATH_SEPARATOR, array(
        WEBSITE_MODULE_PATH . '/custom/lib',
        get_include_path(),
        )));

    $resourceLoader = new \Zend_Application_Module_Autoloader(array(
        'namespace' => 'Custom',
        'basePath' =>  WEBSITE_MODULE_PATH . "/custom",
        )); 

    $routeCustom = new \Zend_Controller_Router_Route(
        'custom/:controller/:action/*',
        array(
            'module'       => 'custom',
            "controller"   => "default",
            "action"       => "default"
            )
        );
    $router->addRoute("custom", $routeCustom);

// ################################ END CUSTOM MODULES ############################################   


// ################################################################################################
// ## TO REGISTER AND AUTOROUTE SABOS MODULES
// ## ADDED BY AHMAD SOMADI
// ################################################################################################

    $autoloader = \Zend_Loader_Autoloader::getInstance();
    $autoloader->registerNamespace('Sabos');

    set_include_path(implode(PATH_SEPARATOR, array(
        WEBSITE_MODULE_PATH . '/sabos/lib',
        get_include_path(),
        )));

    $resourceLoader = new \Zend_Application_Module_Autoloader(array(
        'namespace' => 'Sabos',
        'basePath' =>  WEBSITE_MODULE_PATH . "/sabos",
        )); 

    $routeCustom = new \Zend_Controller_Router_Route(
        'sabos/:controller/:action/*',
        array(
            'module'       => 'sabos',
            "controller"   => "default",
            "action"       => "default"
            )
        );
    $router->addRoute("sabos", $routeCustom);

// ################################ END SABOS MODULES ############################################   


// ################################################################################################
// ## FOR SPECIAL ROUTING. LIST ROUTING DECLARATION ON ==> "HOST/custom/static-route/"   
// ## ADDED BY AHMAD SOMADI
// ################################################################################################

    Website_Helper::removeSession('SESSION_SEO_ONPAGE');

    $seoByStaticRoute = null;
    $listRoute = Custom_Helper::getStaticRoute();

    foreach($listRoute as $route){
        $tempRoute = new \Zend_Controller_Router_Route(
            $route['_patternUrl'],
            array(
                "module" => $route['_module'],
                "controller" => $route['_controller'],
                "action" => $route['_action']
                )
            );

        $router->addRoute($route['_patternUrl'], $tempRoute);

        // set session on page if url path same with custom url path route
        if($_SERVER['REQUEST_URI'] == $route['_patternUrl'] || $_SERVER['REQUEST_URI'] == $route['_patternUrl'] . "/" ){
            if($route['_metaTitle'] || $route['_metaDescription'] || $route['_metaKeyword']){                
                Website_Helper::setSeoOnPage(
                        $route['_metaTitle'], 
                        $route['_metaDescription'], 
                        $route['_metaKeyword'], 
                        $route['_metaH1'], 
                        $route['_metaH2'], 
                        $route['_metaH3']
                    );
            }
        }
    }

// ################################ END SPECIAL ROUTING ############################################   


$front->setRouter($router);

//init the autoloader
Pimcore::initAutoloader();
