<?php

/*
	This is for PHP function helper
	Initial by Ahmad Somadi
*/

use Pimcore\File;
use Pimcore\Model\Asset;
use Pimcore\Tool\Authentication;

class Website_Helper {

	public static function CallApi($method, $url, $data = false, $waitRequest = true)
    {
        $curl = curl_init();
    
        switch (strtoupper($method))
        {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
        
                if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_PUT, 1);
                break;
            default:
                if ($data)
                $url = sprintf("%s?%s", $url, http_build_query($data));
        }
    
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        
        if(!$waitRequest){
            curl_setopt($curl, CURLOPT_TIMEOUT_MS, 250);
        }

        $result = curl_exec($curl);

        if($result === false && $waitRequest){
            $result = 'Curl error: ' . curl_error($curl);
        }   
    
        curl_close($curl);
    
        return $result;
    }

	public static function uploadFileToAsset($params)
    {
		if($params->Type == 'base64'){
			$filename = uniqid().$params->Image['Name'];
			$sourcePath = PIMCORE_SYSTEM_TEMP_DIRECTORY . "/upload-base64" . uniqid() . ".tmp";
            $data = preg_replace("@^data:[^,]+;base64,@", "", $params->Image['Data']);
            File::put($sourcePath, base64_decode($data));
		} else {
			$filename = $params->Image["name"];
			$sourcePath = $params->Image["tmp_name"];
		}

		$parentAsset = Asset::getByPath($params->Path);

		$filename = File::getValidFilename($filename);
        if (empty($filename)) {
            throw new \Exception("The filename of the asset is empty");
        }

        // cek duplikat file
        $filename = self::getSafeFilename($parentAsset->getFullPath(), $filename);
        
        if (!is_file($sourcePath) || filesize($sourcePath) < 1) {
            throw new \Exception("Something went wrong, please check upload_max_filesize and post_max_size in your php.ini and write permissions of /website/var/");
        }
        $asset = Asset::create($parentAsset->getId(), array(
            "filename" => $filename,
            "sourcePath" => $sourcePath
        ));
        @unlink($sourcePath);

        return $asset;
	}

	public static function getSafeFilename($targetPath, $filename)
    {
        $originalFilename = $filename;
        $count = 1;
        if ($targetPath == "/") {
            $targetPath = "";
        }
        while (true) {
            if (Asset\Service::pathExists($targetPath . "/" . $filename)) {
                $filename = str_replace("." . File::getFileExtension($originalFilename), "_" . $count . "." . File::getFileExtension($originalFilename), $originalFilename);
                $count++;
            } else {
                return $filename;
            }
        }
    }

    public static function getIdByClassName($className)
    {
        try{
            $command = "\$class = new Object\\" . $className . "();";
            eval($command);     

            return $class->o_classId;       
        } catch (Exception $ex){
            return 0;
        }   
    }

    // for get data from table/view
    public static function makeQuery($query)
    {						
		$db = Pimcore_Resource_Mysql::get();
		$data = $db->fetchAll($query);

		return $data;
    }

    // for insert/update/delete data from table
    public static function runQuery($query)
    {                           
        $db = Pimcore_Resource_Mysql::get();
        $data = $db->query($query);

        return $data;

    }

    public static function setSession($key, $value)
    {
        try { Zend_Session::start(); } 
        catch(Zend_Session_Exception $e) { session_start(); }

        $_SESSION[$key] = $value;       
    }

    public static function getSession($key)
    {
        try { Zend_Session::start(); } 
        catch(Zend_Session_Exception $e) { session_start(); }

        return $_SESSION[$key];
    }

    public static function removeSession($key)
    {
        try { Zend_Session::start(); } 
        catch(Zend_Session_Exception $e) { session_start(); }
        
        unset($_SESSION[$key]);     
    }
	
    public static function redirect($url)
    {
		$r = new Zend_Controller_Action_Helper_Redirector;
    	$r->gotoUrl($url)->redirectAndExit();    
    }    

    public static function forward($module, $controller, $action, $postData)
    {
        $this->_request->setPost($postData);
        $this->_forward($action, $controller, $module);
    }

    public static function stringCompress($text)
    {   
        return rtrim(strtr(base64_encode(gzdeflate($text, 9)), '+/', '-_'), '=');
    }

    public static function stringDecompress($text)
    {
        return gzinflate(base64_decode(strtr($text, '-_', '+/')));
    }

    public static function getRandomNumber($length)
    {
        $min = pow(10, ($length-1));
        $max = pow(10, $length) - 1;

        return rand($min, $max);
    }

    public static function getRandomClientId()
    {
        $word = $_SERVER['HTTP_USER_AGENT'] . $_SERVER['REMOTE_ADDR'] . microtime() . uniqid();
        return md5($word);
    }

    public static function getRandomPassword($length) 
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*_";
        $password = substr( str_shuffle( $chars ), 0, $length );
        return $password;
    }

    public static function createCsvFile($path, $filename, $arrayData)
    {    
        try {
        
            if (!file_exists($path)) {
                mkdir($path, 0777, true);
            }

            $file = fopen($path . $filename . ".csv", "w");
            
            foreach($arrayData as $data){
                fputcsv($file, $data);
            }

            fclose($file); 

            return 1;

        } catch(Exception $ex) {
        
            return 0;
        
        }
    
    }   

    public static function readCsvFile($filename)
    {            
        $data = array();
        
        try {
        
            $file = fopen($filename,"r");

            while(!feof($file)){
                array_push($data, fgetcsv($file));
            }

            fclose($file);

        } catch(Exception $ex) {}

        return $data;    
    }   

    public static function limitString($input, $maxWords, $maxChars = null)
    {
        $words = preg_split('/\s+/', $input);
        $words = array_slice($words, 0, $maxWords);
        $words = array_reverse($words);

        $chars = 0;
        $truncated = array();

        while(count($words) > 0)
        {
            $fragment = trim(array_pop($words));
            $chars += strlen($fragment);

            if($maxChars)
                if($chars > $maxChars) break;

            $truncated[] = $fragment;
        }

        $result = implode($truncated, ' ');

        if ($input == $result)
        {
            return $input;
        }
        else
        {
            return preg_replace('/[^\w]$/', '', $result) . ' ...';
        }

    }
    
    public static function sendEmail($params = null)
    {
        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';

        try{
            $mail = new \Pimcore\Mail();
            $mail->addTo($params->To);
            
            if($params->Subject){
                $mail->setSubject($params->Subject);
            }

            if($params->Template){
                $mail->setDocument($params->Template);
                $mail->setParams($params->Params);
            }else {
                $mail->setBodyHtml($params->BodyHtml);
            }

            if($params->From){
                $temp = explode(",", $params->From);
                $from = trim($temp[0]);
                $alias = $temp[1] ? trim($temp[1]) : "";
                
                $mail->setFrom($from, $alias);
            }

            if(json_decode($params->Cc)){
                $mail->addCc(json_decode($params->Cc));
            }

            if($params->Bcc){
                $mail->addBcc($params->Bcc);
            }
            
            $mail->send();
            $return->Status = 1;

        } catch (Exception $ex){
            $return->Message = $ex->getMessage();            
        }
 
        return $return;
    }

    public static function convertStringToIndonesiaCurrency($string, $decimalPlaces)
    {
        return 'Rp. ' . number_format($string, $decimalPlaces, ',', '.');
    }

    public static function indonesiaDate($timestamp = '', $date_format = 'd M Y', $suffix = '') 
    {
        if (trim ($timestamp) == ''){
                $timestamp = time ();
        }
        elseif (!ctype_digit ($timestamp)){
            $timestamp = strtotime ($timestamp);
        }

        $date_format = preg_replace ("/S/", "", $date_format);
        $pattern = array (
            '/Mon[^day]/','/Tue[^sday]/','/Wed[^nesday]/','/Thu[^rsday]/',
            '/Fri[^day]/','/Sat[^urday]/','/Sun[^day]/','/Monday/','/Tuesday/',
            '/Wednesday/','/Thursday/','/Friday/','/Saturday/','/Sunday/',
            '/Jan[^uary]/','/Feb[^ruary]/','/Mar[^ch]/','/Apr[^il]/','/May/',
            '/Jun[^e]/','/Jul[^y]/','/Aug[^ust]/','/Sep[^tember]/','/Oct[^ober]/',
            '/Nov[^ember]/','/Dec[^ember]/','/January/','/February/','/March/',
            '/April/','/June/','/July/','/August/','/September/','/October/',
            '/November/','/December/',
        );

        $replace = array ( 'Sen','Sel','Rab','Kam','Jum','Sab','Min',
            'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu','Minggu',
            'Jan','Feb','Mar','Apr','Mei','Jun','Jul','Ags','Sep','Okt','Nov','Des',
            'Januari','Februari','Maret','April','Juni','Juli','Agustus','Sepember',
            'Oktober','November','Desember',
        );

        $date = date ($date_format, $timestamp);
        $date = preg_replace ($pattern, $replace, $date);
        $date = "{$date} {$suffix}";

        return $date;
    }

    public static function exportToExcel($params = null) 
    {

        /* Example data format
        $params->data = array(
                ['Title A1', 'Title B1', 'Title C1', 'Title D1', 'Title E1'],
                ['Value A2', 'Value B2', 'Value C2', 'Value D2', 'Value E2'],
                ['Value A3', 'Value B3', 'Value C3', 'Value D3', 'Value E3'],
                ['Value A4', 'Value B4', 'Value C4', 'Value D4', 'Value E4'],
                ['Value A5', 'Value B5', 'Value C5', 'Value D5', 'Value E5']
                ....................
                ....................
                ....................
            );
        */

        /** Include PHPExcel */
        include_once("vendor/PHPExcel/PHPExcel.php");

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($params->creator)
                                     ->setLastModifiedBy($params->modified)
                                     ->setTitle($params->title)
                                     ->setSubject($params->subject)
                                     ->setDescription($params->description)
                                     ->setKeywords($params->keyword)
                                     ->setCategory($params->category);

        $inc = 1;
        $alphabet = 'A';    
        foreach ($params->data as $row) {
            foreach ($row as $index => $data) {
                $nowAlphabet = chr(ord($alphabet) + $index);
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($nowAlphabet.$inc, $data);
            }

            $inc++;
        }       

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle($params->sheetName);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="'. $params->filename .'.xlsx"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        
        exit;
    }    

    public static function checkPimcoreLogin() 
    {    
        $user = Authentication::authenticateSession();
        return $user;
    }

    public static function checkAuthenticatePimcoreUser($username, $password) 
    {    
        $user = Authentication::authenticatePlaintext($username, $password);
        return $user;
    }

    public static function logoutPimcorePanel($scope) 
    {
        $controller = $scope;

        // clear open edit locks for this session
        \Pimcore\Model\Element\Editlock::clearSession(session_id());

        \Pimcore\Tool\Session::useSession(function ($adminSession) use ($controller) {
            if ($adminSession->user instanceof User) {
                \Pimcore::getEventManager()->trigger("admin.login.logout", $controller, ["user" => $adminSession->user]);
                $adminSession->user = null;
            }

            \Zend_Session::destroy();
        });

        // cleanup pimcore-cookies => 315554400 => strtotime('1980-01-01')
        setcookie("pimcore_opentabs", false, 315554400, "/");        
    }

    public static function setSeoOnPage($title = "", $description = "", $keyword = "", $h1 = "", $h2 = "", $h3 = "") 
    {
        $seo_on_page = (object) array(
            "title" => $title,
            "description" => $description,
            "keyword" => $keyword,
            "h1" => $h1,
            "h2" => $h2,
            "h3" => $h3
        );

        // set session SESSION_SEO_ONPAGE
        self::setSession('SESSION_SEO_ONPAGE', $seo_on_page);
    }

    public static function getSiteUrl() 
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $domainName = $_SERVER['HTTP_HOST'].'/';

        return $protocol . $domainName;
    }    

    public static function checkOrigin()
    {
        header('Access-Control-Allow-Origin: *');        
        $requester = $_SERVER['HTTP_REFERER'];
        $domain_origin = Custom_Helper::getGlobalVariable('GLOBAL_ALLOW_ORIGIN');
        
        if (!$requester) {
            header('Access-Control-Allow-Origin: *');        
        } else {
            $domain_origin = explode(",", $domain_origin);
            if (in_array($requester, $domain_origin)) {
                header("Access-Control-Allow-Origin: ". rtrim($requester, "/"));        
            }
        }
    }    

    public static function downloadFile($file, $name, $mime_type)
    {
        set_time_limit(0);    

        if(!is_readable($file)) die('File not found or inaccessible!');
        $size = filesize($file);
        $name = rawurldecode($name);

        @ob_end_clean();
        if(ini_get('zlib.output_compression'))
        ini_set('zlib.output_compression', 'Off');
        header('Content-Type: ' . $mime_type);
        header('Content-Disposition: attachment; filename="'.$name.'"');
        header("Content-Transfer-Encoding: binary");
        header('Accept-Ranges: bytes');

        if(isset($_SERVER['HTTP_RANGE']))
        {
            list($a, $range) = explode("=",$_SERVER['HTTP_RANGE'],2);
            list($range) = explode(",",$range,2);
            list($range, $range_end) = explode("-", $range);
            $range=intval($range);
            if(!$range_end) {
                $range_end=$size-1;
            } else {
                $range_end=intval($range_end);
            }

            $new_length = $range_end-$range+1;
            header("HTTP/1.1 206 Partial Content");
            header("Content-Length: $new_length");
            header("Content-Range: bytes $range-$range_end/$size");
        } else {
            $new_length=$size;
            header("Content-Length: ".$size);
        }

        $chunksize = 4*(1024*1024);
        $bytes_send = 0;
        if ($file = fopen($file, 'r'))
        {
            if(isset($_SERVER['HTTP_RANGE']))
            fseek($file, $range);

            while(!feof($file) &&
                (!connection_aborted()) &&
                ($bytes_send<$new_length)
            )
            {
                $buffer = fread($file, $chunksize);
                echo($buffer);
                flush();
                $bytes_send += strlen($buffer);
            }
            fclose($file);
        } else {
            die('Error - can not open file.');
        }
    }    

}
